:- use_module(library(lists)).
:- use_module(library(system)).
:- use_module(screenWriting).
%:- use_module(groundBeliefs).
:- use_module(admissibleBeliefs).
%:- use_module(idealBeliefs).


:- dynamic silent/0.
:- sleep(0.1).

user_help	:- 
	write('*******************************************************************************************'),nl,
	write('***  Welcome to HELP for CaSAPI v4.0 - a Credulous and Sceptical Argumenation system!   ***'),nl,
	write('*******************************************************************************************'),nl,
	write('***  Possible control commands (defaults are ab, one and noisy):                        ***'),nl,
	write('***                                                                                     ***'),nl,
	write('***   ?- ab.       - setting the dispute derivation to use admissible belief semantics  ***'),nl,
	write('***   ?- gb.       - setting the dispute derivation to use grounded belief semantics    ***'),nl,
	write('***   ?- ib.       - setting the dispute derivation to use ideal belief semantics       ***'),nl,
	write('***                                                                                     ***'),nl,
	write('***   ?- one.      - ask CaSAPI to find one answer                                      ***'),nl,
	write('***   ?- all.      - display all answers CaSAPI can find                                ***'),nl,
	write('***                                                                                     ***'),nl,
	write('***   ?- noisy.    - use the verbose output mode                                        ***'),nl,
	write('***   ?- silent.   - use the minimal output mode                                        ***'),nl,
	write('***   ?- compact.  - like silent, but with additional output of dialogue structure      ***'),nl,
	write('***                                                                                     ***'),nl,
	write('***   ?- filename(Out)   - places all screen output additionally in the file Out        ***'),nl,
	write('***                      - (provide file name in single quotes)                         ***'),nl,
	write('***                                                                                     ***'),nl,
	write('***   ?- run.      - executes CaSAPI with the currently chosen settings                 ***'),nl,
	write('***                                                                                     ***'),nl,
	write('***   For more advanced control over selection functions etc, please type \'advanced.\'   ***'),nl,
	write('***                                                                                     ***'),nl,
	write('*******************************************************************************************'),nl.

setDefaultModes	:- 	retractall(answer_mode(_)),
			retractall(write_mode(_)),
			retractall(dd_mode(_)),
			retractall(player_choice(_)),
			retractall(argument_choice(_)),
			retractall(sentence_choice(_)),
			retractall(rule_choice(_)),
			retractall(file_name(_)),
			assert(answer_mode(one)),
			assert(write_mode(noisy)),
			assert(dd_mode(ab)),
			assert(player_choice(1)),
			assert(argument_choice(1)),
			assert(sentence_choice(1)),
			assert(rule_choice(1)),
			assert(file_name('./output.log')).

:- 	setDefaultModes,
	nl, nl,
	write('*******************************************************************************************'),nl,
	write('***  Welcome to CaSAPI v4.0 - a Credulous and Sceptical Argumenation system!            ***'),nl,
	write('*******************************************************************************************'),nl,
	write('***  Please decide on the type of dispute derivation you want to employ, choosing       ***'),nl,
	write('***  between grounded beliefs (\'gb.\'), admissible beliefs (\'ab.\') or ideal beliefs      ***'),nl,
	write('***  (\'ib.\') semantics.                            		                        ***'),nl,
	write('***                                                                                     ***'),nl,
	write('***  Further, choose the desired output mode: \'noisy.\' or \'silent.\' or \'compact.\'       ***'),nl,
	write('***                                                                                     ***'),nl,
	write('***  Finally, choose whether you want just \'one.\' answer or \'all.\' answers that         ***'),nl,
	write('***  CaSAPI can find.                                                                   ***'),nl,
	write('***                                                                                     ***'),nl,
	write('***  Invoke CaSAPI by simply typing \'run.\'  Alternatively, you can specify directly:    ***'),nl,
	write('***                                                                                     ***'),nl,
	write('***  \'run(derivation_type, output_mode, number_of_solutions).\'                          ***'),nl,
	write('***                                                                                     ***'),nl,
	write('***  For example, type \'run(ib,noisy,one).\' to find ONE solution according to the ideal ***'),nl,
	write('***  beliefs semantics with detailed output to screen.  Or type \'run(gb,silent,all).\'   ***'),nl,
	write('***  to find ALL solutions in silent mode (with minimal output to screen) using         ***'),nl,
	write('***  the grounded beliefs semantics.  Note, that the full stop is required in each      ***'),nl,
	write('***  case, whereas the single quotes are not part of the input. For more information    ***'),nl,
	write('***  or in case you are stuck, please type \'help.\'                                      ***'),nl,
	write('***                                                                                     ***'),nl,
	write('***  Developed in 2006/07 by Dorian Gaertner for the ArguGrid project.                  ***'),nl,
	write('*******************************************************************************************'),nl,
	nl.

ab	:- 	retractall(dd_mode(_)), assert(dd_mode(ab)).
gb	:- 	retractall(dd_mode(_)), assert(dd_mode(gb)).
ib	:- 	retractall(dd_mode(_)), assert(dd_mode(ib)).

noisy	:-	retractall(write_mode(_)), assert(write_mode(noisy)).
silent	:-	retractall(write_mode(_)), assert(write_mode(silent)).

one	:- 	retractall(answer_mode(_)), assert(answer_mode(one)).
all	:- 	retractall(answer_mode(_)), assert(answer_mode(all)).

filename(N) :- 	retractall(file_name(_)), assert(file_name(N)).
		
run	:-	inputTest, answer_mode(AM), write_mode(WM), dd_mode(DM), run(DM,WM,AM).

auto_check	:-  	consult('./StandardTests/test_01.pl'), run,  
			consult('./StandardTests/test_02.pl'), run, 
			consult('./StandardTests/test_03.pl'), run, 
			consult('./StandardTests/test_04.pl'), run, 
			consult('./StandardTests/test_05.pl'), run, 
			consult('./StandardTests/test_06.pl'), run, 
			consult('./StandardTests/test_07.pl'), run, 
			consult('./StandardTests/test_08.pl'), run, 
			consult('./StandardTests/test_09.pl'), run, 
			consult('./StandardTests/test_10.pl'), run.

run(gb,_,_) :- write('GB dispute derivations are currently not implemented for v4.  Please use an older version of CaSAPI !'), nl.   % runGB(X,Y).
run(ab,X,Y) :- clearScreen, clearFile, runAB(X,Y,Answer), compareAnswer(Answer), sleep(0.5). 
run(ib,_,_) :- write('IB dispute derivations are currently not implemented for v4.  Please use an older version of CaSAPI !'), nl.   % runIB(X,Y).

% FOR VICTORS GUI 
runJava(ab,X,Y,Return) :- user:retractall(javaOutput(_)), name('Output for Java is: ',StartL), 
user:assert(javaOutput(StartL)), run(ab,X,Y), user:retract(javaOutput(Return)).

% RUN FOR PAUL
% runFile(ab,X,Y,F)		:- 	user:retractall(javaOutput(_)), 
%				name('Output for file is: ',StartL), 
%				user:assert(javaOutput(StartL)), run(ab,X,Y),  
%				user:retract(javaOutput(Return)),
%				open(F,write,S), write(S,'\n'), write(S, Return), close(S).

compareAnswer(In)	:-	nl, resultingDefenseSets(ListOfSets), member(In,ListOfSets), 
				write('ALL IS GOOD - answer is in the set of answers'), nl,
				select(In,ListOfSets,X), allAnswersFound(X) .
compareAnswer(In)	:-	nl, resultingDefenseSets(ListOfSets), \+ member(In,ListOfSets), 
				write('ALL IS BAD - answer is NOT in the set of answers ... check order, set not= list'), nl.

allAnswersFound([])	:-	write('ALL IS PERFECT - answer is the only answer in the set of answers'), nl, nl.
allAnswersFound([_|_])	:-	write('OOPS - there are more answers to be discovered ... '), nl, nl.
	
advanced	:-
	write('*******************************************************************************************'),nl,
	write('***  Welcome to ADVANCED HELP for more fine-grained control over CaSAPI v4.0            ***'),nl,
	write('*******************************************************************************************'),nl,
	write('***  There are a variety of choice points in CaSAPI that an advanced user can control   ***'),nl,
	write('***  directly, namely by passing the following to the set/1 command:                    ***'),nl,
	write('***                                                                                     ***'),nl,
	write('***     choiceOfPlayer(X)                                                               ***'),nl,
	write('***     choiceOfArgument(X)                                                             ***'),nl,
	write('***     choiceOfSentence(X)                                                             ***'),nl,
	write('***     choiceOfRule(X)                                                                 ***'),nl,
	write('***                                                                                     ***'),nl,
	write('***  In each case, replace X with the number labelling your choice.  The default is 1.  ***'),nl,
	write('***                                                                                     ***'),nl,
	write('***  PLAYER CHOICE:                                                                     ***'),nl,
	write('***     1 - always prefer the proponent when possible                                   ***'),nl,
	write('***     2 - always prefer the opponent when possible                                    ***'),nl,
	write('***     3 - switch chosen player when possible                                          ***'),nl,
	write('***     4 - pick player randomly when possible                                          ***'),nl,
	write('***                                                                                     ***'),nl,
	write('***  ARGUMENT CHOICE:                                                                   ***'),nl,
	write('***     1 - pick left-most, aiming to complete old arguments                            ***'),nl,
	write('***     2 - pick right-most, tackle newest challenges                                   ***'),nl,
	write('***     3 - pick an argument at random                                                  ***'),nl,
	write('***                                                                                     ***'),nl,
	write('***  SENTENCE CHOICE (also known as selection function):                                ***'),nl,
	write('***     1 - pick left-most, oldest first                                                ***'),nl,
	write('***     2 - pick right-most, newest first                                               ***'),nl,
	write('***     3 - patient selection function                                                  ***'),nl,
	write('***     4 - random selection function                                                   ***'),nl,
	write('***                                                                                     ***'),nl,
	write('***  RULE CHOICE:                                                                       ***'),nl,
	write('***     1 - select first applicable rule according to order in input file               ***'),nl,
	write('***     2 - select rule with fewest assumptions in the body                             ***'),nl,
	write('***     3 - select rule with fewest sentences in the body                               ***'),nl,
	write('***     4 - select a rule at random from all applicable rules                           ***'),nl,
	write('***                                                                                     ***'),nl,
	write('*******************************************************************************************'),nl.

set(choiceOfPlayer(X))	:- integer(X), X > 0, X < 5, retractall(player_choice(_)), assert(player_choice(X)).
set(choiceOfPlayer(X))	:- ( \+ integer(X) ; ( X < 1 ; X > 4) ), nl, write('Invalid input. Please check the advanced help.'), nl.

set(choiceOfArgument(X)):- integer(X), X > 0, X < 4, retractall(argument_choice(_)), assert(argument_choice(X)).
set(choiceOfArgument(X)):- ( \+ integer(X) ; ( X < 1 ; X > 3) ), nl, write('Invalid input. Please check the advanced help.'), nl.

set(choiceOfSentence(X)):- integer(X), X > 0, X < 5, retractall(sentence_choice(_)), assert(sentence_choice(X)).
set(choiceOfSentence(X)):- ( \+ integer(X) ; ( X < 1 ; X > 4) ), nl, write('Invalid input. Please check the advanced help.'), nl.

set(choiceOfRule(X))	:- integer(X), X > 0, X < 5, retractall(rule_choice(_)), assert(rule_choice(X)).
set(choiceOfRule(X))	:- ( \+ integer(X) ; ( X < 1 ; X > 4) ), nl, write('Invalid input. Please check the advanced help.'), nl.

clearFile	:- file_name(N),open(N,write,S), write(S,'\n'), close(S).

% Some verification on input file:
% 	* assumptions do not occur in the head of rules
% 	* contraries are only defined for assumptions
% 	* every rule has at least the head ... checked by Prolog ( myRule/2 )
%	* RHS of a rule is a list
%	* every assumption has a contrary

inputTest 	:- 	testParameters,
			\+ assInHeadOfRules, 
			\+ contrary4NonAsm,
			\+ rhsIsNotList,
			\+ assWithoutCon,
			nl, write('Input file checked, no obvious syntactic mistakes.'), nl.

testParameters	:-	( answer_mode(all) ; answer_mode(one) ),
			( write_mode(silent) ; ( write_mode(noisy) ; write_mode(compact) ) ),
			( dd_mode(ab) ; ( dd_mode(gb) ; dd_mode(ib) ) ).

assInHeadOfRules:- 	myAsm(X), 
			myRule(X,_), 
			write('Incorrect Input Error 1 - An assumption occurred in the head of a rule !'), nl.

contrary4NonAsm	:-	contrary(X,_), 
			\+ myAsm(X),
			write('Incorrect Input Error 2 - A contrary is defined for a Non-assumption !'), nl.

rhsIsNotList	:-	myRule(_,X), 
			\+ is_list(X),
			write('Incorrect Input Error 3 - A rule was found with an invalid RHS syntax !'), nl.

assWithoutCon	:-	myAsm(X),
			\+ contrary(X,_),
			write('Incorrect Input Error 4 - every assumption needs a contrary, even if that contrary is not defined !'), nl.

